package pt.caf_pbs.schooldiskclient.ui;

import android.app.Activity;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.os.Bundle;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import pt.caf_pbs.schooldiskclient.R;
import pt.caf_pbs.schooldiskclient.dto.InstructorDTO;
import pt.caf_pbs.schooldiskclient.dto.Mapper;
import pt.caf_pbs.schooldiskclient.helper.Utils;
import pt.caf_pbs.schooldiskclient.model.Instructor;
import pt.caf_pbs.schooldiskclient.service.RequestsService;



public class InstructorActivity extends AppCompatActivity {

    private int mode;
    private String initials;
    private String name;

    private EditText etInitials, etName;
    private Button btOp, btCancel;
    private ProgressBar pdRing;
    boolean exception = false;
    String exceptionMessage = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_instructor);
        setRequestedOrientation(ActivityInfo.SCREEN_ORIENTATION_PORTRAIT);
        initials = null;
        name = null;
        pdRing = (ProgressBar) findViewById(R.id.progressBar);
        pdRing.setVisibility(ProgressBar.INVISIBLE);
        etInitials = (EditText) findViewById(R.id.etInitials);
        etName = (EditText) findViewById(R.id.etName);

        btOp = (Button)findViewById(R.id.btOp);
        btOp.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {


                int editMode = Utils.ACTIVITY_MODE_NOT_EDITING;
                switch(mode){
                    case Utils.REQUEST_CODE_ADD_ACTIVITY:
                        try {
                            name = etName.getText().toString();
                            initials = etInitials.getText().toString();
                            Instructor instructor = new Instructor(initials, name);
                            InstructorDTO instuctorDTO = Mapper.instructor2InstructorDTO(instructor);
                            postInstructor2WS(instuctorDTO);

                        }catch (Exception e){
                            exceptionMessage = e.getMessage();
                            exception = true;
                        }
                        break;
                    case Utils.REQUEST_CODE_DELETE_ACTIVITY:
                        deleteInstructor2WS(initials);

                        break;
                    case Utils.REQUEST_CODE_EDIT_ACTIVITY:
                        try {
                            name = etName.getText().toString();
                            Instructor instructor = new Instructor(initials, name);
                            InstructorDTO instuctorDTO = Mapper.instructor2InstructorDTO(instructor);
                            putInstructor2WS(initials,instuctorDTO);
                        }catch (Exception e){
                            exceptionMessage = e.getMessage();
                            exception = true;
                        }
                        break;
                    default:
                        Toast.makeText(InstructorActivity.this,Utils.UNKNOWN_MODE,Toast.LENGTH_SHORT).show();
                }


            }
        });
        btCancel = (Button)findViewById(R.id.btCancel);
        btCancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                Intent intent = new Intent();
                setResult(Activity.RESULT_CANCELED, intent);
                finish();
            }
        });

        Intent intent = getIntent();
        mode  = intent.getIntExtra(Utils.OPERATION, Utils.REQUEST_CODE_DELETE_ACTIVITY);
        configureUI();

        if(mode == Utils.REQUEST_CODE_EDIT_ACTIVITY || mode == Utils.REQUEST_CODE_DELETE_ACTIVITY) {
            initials = intent.getStringExtra(Utils.ID);
            name = intent.getStringExtra(Utils.NAME);
        }
        getPessoaFromWS();
    }

    private void checkOperationResult(){
        if(exception == false) {
            Intent intent = new Intent();
            setResult(Activity.RESULT_OK, intent);
            finish();
        }else{
            Toast.makeText(InstructorActivity.this,exceptionMessage,Toast.LENGTH_SHORT).show();
        }
    }
    private void configureUI(){
        switch(mode){
            case Utils.REQUEST_CODE_ADD_ACTIVITY:
                etName.setEnabled(true);
                etInitials.setEnabled(true);
                btOp.setText("Inserir");
                break;
            case Utils.REQUEST_CODE_DELETE_ACTIVITY:
                etName.setEnabled(false);
                etInitials.setEnabled(false);
                btOp.setText("Eliminar");
                break;
            case Utils.REQUEST_CODE_EDIT_ACTIVITY:
                etName.setEnabled(true);
                etInitials.setEnabled(true);
                btOp.setText("Alterar");
                break;
            default:
                Toast.makeText(InstructorActivity.this,"Mode: desconhecido",Toast.LENGTH_SHORT).show();
        }
    }
    private void setDataUI(){
        if((mode != Utils.REQUEST_CODE_EDIT_ACTIVITY && mode != Utils.REQUEST_CODE_DELETE_ACTIVITY)
                || ((mode == Utils.REQUEST_CODE_EDIT_ACTIVITY || mode == Utils.REQUEST_CODE_DELETE_ACTIVITY)
                        && initials == null)){
            etName.setText("");
            etInitials.setText("");
        }
        etName.setText(name);
        etInitials.setText(initials);
    }

    private void getPessoaFromWS() {
        setDataUI();
    }
    private void postInstructor2WS(InstructorDTO instuctorDTO) {
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);
                    }
                });
                RequestsService.addInstructor(instuctorDTO, InstructorActivity.this);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.INVISIBLE);
                        checkOperationResult();
                    }
                });
            }
        }.start();
    }
    private void putInstructor2WS(String id, InstructorDTO instuctorDTO) {
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);

                    }
                });

                RequestsService.updateInstructor(id, instuctorDTO, InstructorActivity.this);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.INVISIBLE);
                        checkOperationResult();
                    }
                });
            }
        }.start();
    }
    private void deleteInstructor2WS(String id) {
        new Thread() {
            public void run() {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.VISIBLE);
                    }
                });

                RequestsService.deleteInstructor(id, InstructorActivity.this);
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        pdRing.setVisibility(ProgressBar.INVISIBLE);
                        checkOperationResult();
                    }
                });
            }
        }.start();
    }

}
